(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 13.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      6175,        178]
NotebookOptionsPosition[      4858,        148]
NotebookOutlinePosition[      5283,        165]
CellTagsIndexPosition[      5240,        162]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{"A", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"B", "=", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"c", "=", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"d", "=", 
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "4"}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.9718656167408733`*^9, 3.9718657769366627`*^9}, {
  3.971865814860943*^9, 3.971865850936736*^9}, {3.9718669413713093`*^9, 
  3.971866976335094*^9}, {3.9718677150049477`*^9, 3.97186779781826*^9}, {
  3.971868388714117*^9, 3.971868461552137*^9}, {3.971868904062935*^9, 
  3.97186890445347*^9}, {3.971869042654211*^9, 3.971869043086821*^9}, {
  3.971870140399159*^9, 3.9718702120373697`*^9}, {3.9718708026729097`*^9, 
  3.971870837303728*^9}, {3.9718726569607887`*^9, 3.971872674867331*^9}, {
  3.971872725837008*^9, 3.971872731641903*^9}},
 CellLabel->
  "In[104]:=",ExpressionUUID->"6818c6b6-c7b4-4873-b546-b64fea2ae825"],

Cell["Tetraedro", "Text",
 CellChangeTimes->{{3.9718708518966417`*^9, 3.9718708587234707`*^9}, {
  3.971872678810965*^9, 
  3.9718726830562887`*^9}},ExpressionUUID->"bc7ab85c-808e-4dea-a581-\
17a12b7fd329"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Det", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"B", "-", "A"}], ",", 
    RowBox[{"c", "-", "A"}], ",", 
    RowBox[{"d", "-", "A"}]}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.9718708617549953`*^9, 3.971870892238627*^9}, {
  3.971872691805531*^9, 3.9718727190748577`*^9}, {3.97187275301891*^9, 
  3.971872787314899*^9}},
 CellLabel->
  "In[109]:=",ExpressionUUID->"03e2c36e-a1e3-4fc5-ad25-b04c2a42ecf5"],

Cell[BoxData["14"], "Output",
 CellChangeTimes->{
  3.9718708972227163`*^9, {3.971872757464377*^9, 3.9718727877049828`*^9}},
 CellLabel->
  "Out[109]=",ExpressionUUID->"4b256e11-fe92-47f1-90cc-6bd16c6150b0"]
}, Open  ]],

Cell["Volumen", "Text",
 CellChangeTimes->{{3.9718708518966417`*^9, 3.9718708587234707`*^9}, {
  3.9718709110467052`*^9, 3.9718709217256517`*^9}, {3.971872796038978*^9, 
  3.971872796938798*^9}},ExpressionUUID->"f46ea9a7-8b06-4709-88cc-\
617a53883e7b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"1", "/", "6"}], 
  RowBox[{"Abs", "[", 
   RowBox[{"Dot", "[", 
    RowBox[{
     RowBox[{"B", "-", "A"}], ",", 
     RowBox[{"Cross", "[", 
      RowBox[{
       RowBox[{"c", "-", "A"}], ",", 
       RowBox[{"d", "-", "A"}]}], "]"}]}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.971870926367196*^9, 3.9718709933981123`*^9}, {
  3.971872801830284*^9, 3.97187282377639*^9}},
 CellLabel->
  "In[110]:=",ExpressionUUID->"2ed0e630-c7c5-4646-a567-268dd3db6ee4"],

Cell[BoxData[
 FractionBox["7", "3"]], "Output",
 CellChangeTimes->{3.971870994240766*^9, 3.9718728267056923`*^9},
 CellLabel->
  "Out[110]=",ExpressionUUID->"fbfdf101-c3c1-4cf9-8404-a1adf860bf3c"]
}, Open  ]],

Cell["Altura", "Text",
 CellChangeTimes->{{3.9718708518966417`*^9, 3.9718708587234707`*^9}, {
  3.9718709110467052`*^9, 3.9718709217256517`*^9}, {3.971871008175789*^9, 
  3.971871010074559*^9}, {3.971872832789237*^9, 
  3.971872834456236*^9}},ExpressionUUID->"3327914f-2859-4343-8d2d-\
bab1e744ad85"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{"h", "==", 
   RowBox[{"3", "*", 
    RowBox[{
     RowBox[{"7", "/", "3"}], "/", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"1", "/", "2"}], 
       RowBox[{"Norm", "[", 
        RowBox[{"Cross", "[", 
         RowBox[{
          RowBox[{"B", "-", "A"}], ",", 
          RowBox[{"c", "-", "A"}]}], "]"}], "]"}]}], ")"}]}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.971871012948642*^9, 3.9718710297314262`*^9}, {
  3.971872838611897*^9, 3.971872895131518*^9}},
 CellLabel->
  "In[111]:=",ExpressionUUID->"a0070462-2604-4a9d-8ec8-fce11dd1a086"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"h", "\[Rule]", 
    RowBox[{"7", " ", 
     SqrtBox[
      FractionBox["2", "15"]]}]}], "}"}], "}"}]], "Output",
 CellChangeTimes->{3.9718710302246923`*^9, 3.971872898492787*^9},
 CellLabel->
  "Out[111]=",ExpressionUUID->"35447dcf-76b0-4754-8705-a80c25016843"]
}, Open  ]]
},
WindowSize->{1307, 666},
WindowMargins->{{Automatic, 64}, {Automatic, 55}},
Magnification:>1.25 Inherited,
FrontEndVersion->"14.3 para Mac OS X ARM (64-bit) (July 8, 2025)",
StyleDefinitions->"Default.nb",
ExpressionUUID->"b14c32af-361e-497c-b469-f48e546e10d9"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1151, 26, 226, "Input",ExpressionUUID->"6818c6b6-c7b4-4873-b546-b64fea2ae825"],
Cell[1712, 48, 206, 4, 84, "Text",ExpressionUUID->"bc7ab85c-808e-4dea-a581-17a12b7fd329"],
Cell[CellGroupData[{
Cell[1943, 56, 438, 11, 105, "Input",ExpressionUUID->"03e2c36e-a1e3-4fc5-ad25-b04c2a42ecf5"],
Cell[2384, 69, 207, 4, 83, "Output",ExpressionUUID->"4b256e11-fe92-47f1-90cc-6bd16c6150b0"]
}, Open  ]],
Cell[2606, 76, 252, 4, 84, "Text",ExpressionUUID->"f46ea9a7-8b06-4709-88cc-617a53883e7b"],
Cell[CellGroupData[{
Cell[2883, 84, 496, 14, 105, "Input",ExpressionUUID->"2ed0e630-c7c5-4646-a567-268dd3db6ee4"],
Cell[3382, 100, 197, 4, 104, "Output",ExpressionUUID->"fbfdf101-c3c1-4cf9-8404-a1adf860bf3c"]
}, Open  ]],
Cell[3594, 107, 300, 5, 84, "Text",ExpressionUUID->"3327914f-2859-4343-8d2d-bab1e744ad85"],
Cell[CellGroupData[{
Cell[3919, 116, 602, 18, 105, "Input",ExpressionUUID->"a0070462-2604-4a9d-8ec8-fce11dd1a086"],
Cell[4524, 136, 318, 9, 155, "Output",ExpressionUUID->"35447dcf-76b0-4754-8705-a80c25016843"]
}, Open  ]]
}
]
*)

